// VERSION: Scilab: 5.4.1 
// OS: windows 7 
// CAPTION: PROGRAM TO GENERATE COMMON DISCRETE TIME SIGNALS

clc;
clear;
close;

//UNIT IMPULSE SIGNAL
L=input('Enter the Length='); //SET LIMIT
n=-L:L;
x=[zeros(1,L),ones(1,1),zeros(1,L)];
subplot(2,4,1);
a=gca();
a.y_location ="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(n,x)
title ('Unit Impulse Signal' );
xlabel('Samples n');
ylabel('Amplitude');

// UNIT STEP SIGNAL
y=[zeros(1,L),ones(1,L+1)];
subplot(3,4,2);
b=gca();
b.y_location ="middle";
b.foreground = 5; 
b.font_color = 5;
b.font_style = 5;
plot2d3(n,y)
title('Unit Step Signal' );
xlabel('Samples n');
ylabel('Amplitude');

//UNIT RAMP SIGNAL
z=[zeros(1,L),0:L],
subplot(2,4,3)
c=gca();
c.y_location ="middle";
c.foreground = 5; 
c.font_color = 5;
c.font_style = 5;
plot2d3(n,z)
title('Unit Ramp Signal' );
xlabel('Samples n');
ylabel('Amplitude');

// EXPONENTIALLY INCREASING SEQUENCE

n=0:1:10;
x=exp(n);
subplot(2,4,4);
d=gca();
d.x_location="origin";
d.y_location ="origin";
d.foreground = 5; 
d.font_color = 5;
d.font_style = 5;
plot2d3(n,x)
title('Exponentially Increasing Sequence');
xlabel('Samples n');
ylabel('Amplitude');

// EXPONENTIALLY DECREASING SEQUENCE
n=0:1:10;
x=exp(-n);
subplot(2,4,5);
d=gca();
d.x_location="origin";
d.y_location ="origin";
d.foreground = 5; 
d.font_color = 5;
d.font_style = 5;
plot2d3(n,x)
title('Exponentially Decreasing Sequence');
xlabel('Samples n');
ylabel('Amplitude');

// SINE WAVE
t=0:0.04:1;
x=sin(2*%pi*t);
subplot(2,4,6);
a=gca();
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3(t,x);
title('Sine Wave')
xlabel('Samples n');
ylabel('Amplitude');

// COSINE WAVE
t=0:0.04:1;
x=cos(2*%pi*t);
subplot(2,4,7);
b=gca();
b.foreground = 5; 
b.font_color = 5;
b.font_style = 5;
plot2d3(t,x);
title('Cosine Wave')
xlabel('Samples n');
ylabel('Amplitude');

//INPUT:
//Enter the Length=5
